
#include "Port.h"

void SetBit(unsigned char *Data, char Bit, char State)
{
	unsigned char Temp1, Temp2;
	Temp1 = *Data >> Bit;
	Temp2 = *Data << (8 - Bit);
	Temp2 >>= 8 - Bit;
	if(State == 1)
		Temp1 |= 0x01;
	else
		Temp1 &= 0xfe;
	Temp1 <<= Bit;
	*Data = Temp1 | Temp2;
}

unsigned char GetBit(unsigned char Data, char Bit)
{
	Data <<= 7 - Bit;
	Data >>= 7;
	return Data;
}

#ifndef MaxCtr
	#define MaxCtr 100
#endif
#ifndef MaxBtns
	#define MaxBtns 8
#endif

// Scans buttons(Touch Buttons) on specified port and returns result.
unsigned int getkeyex(unsigned char Port)
{
	static unsigned char i = 0;
	static unsigned char PrevStatus = 0x00; //0xff;
	static unsigned char PrevPressed = 0x00;
	static unsigned int PressCtr[MaxBtns] = {0};
	static unsigned char Ctr[MaxBtns] = {0};
	unsigned char Pressed = 0x00;
	unsigned char CurStatus = 0x00;
	unsigned int Result;
	unsigned char A, B;
	A = GetBit(Port, i);
	B = GetBit(PrevStatus, i);
	switch(A)
	{
	case 0:
		switch(B)
		{
		case 0:
			Ctr[i] = 0;
			PressCtr[i] ++;
			if( GetBit( PrevPressed, i) )
			{
				if( PressCtr[i] > MaxCtr + (MaxCtr / 2))
				{
					SetBit( &Pressed, i, 1 );
					PressCtr[i] = 0;
				}
				else
					SetBit( &Pressed, i, 0 );
				break;
			}
			if( PressCtr[i] > MaxCtr * 3 )
			{
				SetBit(&PrevPressed, i, 1);
				PressCtr[i] = 0;
			}
			break;
		case 1:
			if(Ctr[i] == MaxCtr)	// if Button pressed for with duration CtrMax
			{
				Ctr[i] = 0;
				SetBit(&PrevStatus, i, 0);
				SetBit(&CurStatus, i, 1);
			}
			else
				Ctr[i]++;
			//PressCtr[i] = 0;
			break;
		}
		break;
	case 1:
		switch(B)
		{
		case 0:
			SetBit(&PrevStatus, i, 1);
			Ctr[i] = 0;
			PressCtr[i] = 0;
			SetBit(&PrevPressed, i, 0);
			break;
		case 1:
			Ctr[i] = 0;
			PressCtr[i] = 0;
			SetBit(&PrevPressed, i, 0);
			break;
		}
		break;
	}
	i ++;
	if(i >= MaxBtns)
		i = 0;
	Result = Pressed;
	Result <<= 8;
	Result |= (unsigned int)CurStatus;
	return Result;
}

